IF EXISTS (SELECT 1 FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_PROD_AUDIT')
BEGIN
	DROP TRIGGER TRG_EST_PROD_AUDIT
END

GO
CREATE OR ALTER TRIGGER [dbo].[TRG_EST_PROD_AUDIT] ON [dbo].[EST_PROD] 
FOR UPDATE,DELETE
AS
 
IF NOT UPDATE(DT_ULT_ATU) AND NOT UPDATE(STS_PROD)
BEGIN
	RETURN
END

-- SE FOR UPDATE
IF EXISTS (SELECT TOP 1 CD_EMP FROM INSERTED )
BEGIN
	INSERT INTO EST_PROD_AUDIT (
		CD_EMP,
		CD_PROD,
		DS_PROD,
		DS_PROD_ANT,
		DS_USUAL,
		DS_USUAL_ANT,
		STS_PROD,
		STS_PROD_ANT,
		LISTA_PROD,
		LISTA_PROD_ANT,
		NR_NCM,
		NR_NCM_ANT,
		CD_USU,
		CD_USU_ANT,
		DT_CAD,
		DT_CAD_ANT,
		DT_ULT_ATU,
		DT_ULT_ATU_ANT,
		DT_CAD_AUDIT,
		FLAG_PRODUTO_CONTROLADO,
		FLAG_PRODUTO_CONTROLADO_ANT,
		CTR_LOTE,
		CTR_LOTE_ANT,
		CONTROLE_SNGPC,
		CONTROLE_SNGPC_ANT,
		ANTIBIOTICO,
		ANTIBIOTICO_ANT,
		FLAG_REQUER_RECEITA,
		FLAG_REQUER_RECEITA_ANT,
		CD_MOTIVO_STS,
		CD_MOTIVO_STS_ANT)
	 SELECT 
		D.CD_EMP,
		D.CD_PROD,
		I.DS_PROD,
		D.DS_PROD,
		I.DS_USUAL,
		D.DS_USUAL,
		I.STS_PROD,
		D.STS_PROD,
		I.LISTA_PROD,
		D.LISTA_PROD,
		I.NR_NCM,
		D.NR_NCM,
		I.CD_USU,
		D.CD_USU,
		I.DT_CAD,
		D.DT_CAD,
		I.DT_ULT_ATU,
		D.DT_ULT_ATU,
		GETDATE() DT_CAD_AUDIT,
		I.FLAG_PRODUTO_CONTROLADO,
		D.FLAG_PRODUTO_CONTROLADO,
		I.CTR_LOTE,
		D.CTR_LOTE,
		I.CONTROLE_SNGPC,
		D.CONTROLE_SNGPC,
		I.ANTIBIOTICO,
		D.ANTIBIOTICO,
		I.FLAG_REQUER_RECEITA,
		D.FLAG_REQUER_RECEITA,
		I.CD_MOTIVO_STS,
		D.CD_MOTIVO_STS
	 FROM 
		INSERTED I 
		INNER JOIN DELETED D ON 
		I.CD_EMP = D.CD_EMP AND 
		I.CD_PROD = D.CD_PROD
	END
ELSE
	BEGIN
		INSERT INTO EST_PROD_AUDIT (
		CD_EMP,
		CD_PROD,
		DS_PROD,
		DS_PROD_ANT,
		DS_USUAL,
		DS_USUAL_ANT,
		STS_PROD,
		STS_PROD_ANT,
		LISTA_PROD,
		LISTA_PROD_ANT,
		NR_NCM,
		NR_NCM_ANT,
		CD_USU,
		CD_USU_ANT,
		DT_CAD,
		DT_CAD_ANT,
		DT_ULT_ATU,
		DT_ULT_ATU_ANT,
		DT_CAD_AUDIT,
		FLAG_PRODUTO_CONTROLADO,
		FLAG_PRODUTO_CONTROLADO_ANT,
		CTR_LOTE,
		CTR_LOTE_ANT,
		CONTROLE_SNGPC,
		CONTROLE_SNGPC_ANT,
		ANTIBIOTICO,
		ANTIBIOTICO_ANT,
		FLAG_REQUER_RECEITA,
		FLAG_REQUER_RECEITA_ANT,
		CD_MOTIVO_STS,
		CD_MOTIVO_STS_ANT)

		 SELECT 
			D.CD_EMP,
			D.CD_PROD,
			'',
			D.DS_PROD,
			'',
			D.DS_USUAL,
			0 STS_PROD,
			D.STS_PROD,
			0 LISTA_PROD,
			D.LISTA_PROD,
			'' NR_NCM,
			D.NR_NCM,
			0 CD_USU,
			D.CD_USU,
			NULL DT_CAD,
			D.DT_CAD,
			NULL DT_ULT,
			D.DT_ULT_ATU,
			GETDATE() DT_CAD_AUDIT,
			0,
			D.FLAG_PRODUTO_CONTROLADO,
			0,
			D.CTR_LOTE,
			0,
			D.CONTROLE_SNGPC,
			0,
			D.ANTIBIOTICO,
			0,
			D.FLAG_REQUER_RECEITA			
			,0
			,D.CD_MOTIVO_STS
		 FROM 
			DELETED D
	END